// Create IpAccessSctp MO

ECHO "Create IpAccessSctp MO"
CREATE
(
     parent "ManagedElement=1,IpSystem=1"
     identity "Iub"
     moType IpAccessSctp
     exception none
     nrOfAttributes 2
         ipAccessHostEtRef1 Ref "ManagedElement=1,IpSystem=1,IpAccessHostEt=1"
         userLabel String "IpAccessSctp_Iub"
)
 
// Create Sctp MO
 
ECHO "Create Sctp MO"
CREATE
(
        parent "ManagedElement=1,TransportNetwork=1"
        identity "1"
        moType Sctp
        exception none
        nrOfAttributes 13
            associationMaxRtx Integer 12
            initialAdRecWin Integer 16384
            initialRto Integer 20
            ipAccessSctpRef Reference "ManagedElement=1,IpSystem=1,IpAccessSctp=Iub"
            maximumRto Integer 40
            maxUserDataSize Integer 556
            mBuffer Integer 16
            minimumRto Integer 10
            nThreshold Integer 12
            numberOfAssociations Integer 2
            pathMaxRtx Integer 6
            rpuId Ref "ManagedElement=1,SwManagement=1,ReliableProgramUniter=sctp_host"
            userLabel String "Sctp_1"
)
 
////////////////////////////////////////////////////////////
//FDN=ManagedElement=1,NodeBFunction=1,Iub= Iub_AN0018
////////////////////////////////////////////////////////////
CREATE
(
     parent "ManagedElement=1,NodeBFunction=1"
     identity "Iub_AN0018"
     moType Iub
     exception none
     nrOfAttributes 4
         controlPlaneTransportOption Struct
             nrOfElements 2
             atm Boolean false
             ipV4 Boolean true
         userPlaneTransportOption Struct
             nrOfElements 2
             atm Boolean false
             ipV4 Boolean true
         rbsId Integer 241
         userPlaneIpResourceRef Ref "ManagedElement=1,IpSystem=1,IpAccessHostEt=1"
)
 
////////////////////////////////////////////////////////////
//FDN=ManagedElement=1,NodeBFunction=1,Iub=Iub_AN0018,NbapCommon=1
////////////////////////////////////////////////////////////
CREATE
(
     parent "ManagedElement=1,NodeBFunction=1,Iub=Iub_AN0018"
     identity "1"
     moType NbapCommon
     exception none
     nrOfAttributes 4
         auditRetransmissionT Integer 5
         l2EstablishReqRetryT Integer 1
         l2EstablishSupervisionT Integer 30
         l3EstablishSupervisionT Integer 30
)
 
////////////////////////////////////////////////////////////
//FDN=ManagedElement=1,NodeBFunction=1,Iub=Iub_AN0018,NbapDedicated=1
////////////////////////////////////////////////////////////
CREATE
(
     parent "ManagedElement=1,NodeBFunction=1,Iub=Iub_AN0018"
     identity "1"
     moType NbapDedicated
     exception none
     nrOfAttributes 2
         l2EstablishReqRetryT Integer 1
         l2EstablishSupervisionT Integer 30
)
 
SET
(
     mo "ManagedElement=1,NodeBFunction=1"
     exception none
         featureStateIncreasedCellCarrierSupport Integer 1
)
 
